﻿<%@ page language="C#" autoeventwireup="true" inherits="SisenMESS_Mobile_Main, App_Web_edxuepa5" %>
<!DOCTYPE html>
<html manifest="SisenMESS-Mobile-Main.appcache" >
<head runat="server">
    <title>布谷鸟2015</title>
    <script src="Scripts/MyDate.js"></script>
    <script src="Scripts/UserMsgClass.js"></script>
    <script type="text/javascript">
        //禁止返回键
        javascript:window.history.forward(1); 

        //Web连接
        var _WebSocket;
        //服务器地址
        var _ServerIp;
        //用户名
        var _UserNo;
        //用户显示姓名
        var _UserTName;
        //密码
        var _Password;
        //用户在线状态 : 5是手机在线,6是手机隐身
        var _UserOnline;
        //是否是用户主动退出(以免在断开事件中响应)
        var _IsUserLogout = false;
        //是否登录
        var _IsLogin = false;
        //用户断线重连
        var _UserReConnect;
        //是否正在断线重连
        var _Is_UserReConnecting = false;
        //用户在线状态线程
        var _StartUserOnlineState;
        //定时扫描服务器端未读消息
        var _UserScanServerMsg;
        //当前打开的页面名称(URL)
        var _PageTempName;
        //当前打开的用户头像
        var _TempMsgUserIconUrl;
        //当前用户的头像
        var _MyUserIconUrl;
        //是否播放声音
        var _IsPlaySound = false;
        //连接服务器
        function ConnectToServer()
        {
            try
            {   
                _WebSocket = null;
                if(_UserReConnect ==null)
                {
                    _UserReConnect = new Worker("Scripts/UserReConnectToServer.js");
                //_UserReConnect.onmessage = aaaaaaaa;
                }
                _ServerIp = document.getElementById("txt_ServerIp").value;
                _UserNo = document.getElementById("txt_UserNo").value;
                _Password = document.getElementById("txt_UserPass").value;
                _UserOnline = document.getElementById("txt_UserOnline").value;
                _MyUserIconUrl = document.getElementById("txt_UserImageIcon").value;
                _UserTName = document.getElementById("txt_UserTName").value;
                
                if ("WebSocket" in window) {
                    _WebSocket = new WebSocket("ws://" + _ServerIp + ":9662/SisenMESS-Mobile");
                }
                else if ("MozWebSocket" in window) {
                    _WebSocket = new MozWebSocket("ws://" + _ServerIp + ":9662/SisenMESS-Mobile");
                }
                _IsLogin = false;
                _IsUserLogout = false;

                _WebSocket.onopen = WSonOpen;
                _WebSocket.onmessage = WSonMessage;
                _WebSocket.onclose = WSonClose;
                _WebSocket.onerror = WSonError;
            }
            catch (e) {
                ShowMsgBox("无法连接到服务器...");
            }
        }

        //向服务器发送消息
        function SendMsgToServer(msg) 
        {
            try 
            {
                _WebSocket.send(msg);
            }
            catch (e) {
            }
        }

        //登录成功，发送验证信息
        function WSonOpen() 
        {
            try 
            {
                //停止用户重连线程
                _UserReConnect.terminate();
                _UserReConnect = null;
            }
            catch (ex) {
            }
            setTimeout(WSonOpen_Fun, 500);
        }
        //发送验证信息
        function WSonOpen_Fun() 
        {
            try
            {
                var logininfo = "SetUserNo\n" + _UserNo + "\n" + _UserOnline;
                SendMsgToServer(logininfo);
            }
            catch (e) {
                ShowMsgBox("身份验证出错..." + e.toString());
            }
        }

        //收到消息
        function WSonMessage(event) {
            try {
                var tempmsg = event.data.split('\n');
                switch (tempmsg[0]) 
                {
                    case "SetUserNo":
                        _IsLogin = true;
                        //关闭信息提醒
                        CloseMsgBox();
                        //显示出状态栏和导航栏
                        //ShowOrHideToolBar(true);
                        //document.getElementById("HeaderBar").style.visibility = "visible";
                        //document.getElementById("FootBar").style.visibility = "visible";
                        
                        //启用在线状态线程
                        _StartUserOnlineState = new Worker("Scripts/UserOnlineStateClass.js");
                        _StartUserOnlineState.onmessage = UserOnlineSendState;
                        
                        //启用定时操作服务器端未读消息线程
                        _UserScanServerMsg = new Worker("Scripts/UserScanMsgClass.js");
                        _UserScanServerMsg.onmessage = UserScanServerMsgFun;
                        
                        //说明登录成功，打开消息记录页面
                        //_PageTempName = "Msg/MsgList.aspx?UserNo=" + _UserNo;
                        //GoToURL("Msg/MsgList.aspx?UserNo=" + _UserNo);
                        OpenMsgList();
                        break;
                    case "Msg"://有消息来
                        PlaySound("msg");
                        //保存消息记录
                        SaveLocalMsgList(_UserNo,tempmsg[1],tempmsg[4].replace(/SisenMESS_ReLine_Code/g,"<br>"),tempmsg[2] ,"0");
                        //保存最近联系人
                        SaveLastUserList(_UserNo,tempmsg[1]);
                        
                        //保存用户最后通讯概要
                        SaveUserLastMsgSummary(_UserNo,tempmsg[1],tempmsg[3],tempmsg[5]);
                        
                        //是否显示在消息上的提示小圆点
                        var isshowcccyy1 = true;
                        try
                        {
                            window.frames[0].RecvUserMsg(tempmsg[1],tempmsg[4].replace(/SisenMESS_ReLine_Code/g,"<br>"),tempmsg[2]);//MsgList.aspx页面
                            isshowcccyy1 = false;
                        }
                        catch (ex)
                        {
                        }
                        try
                        {
                            var recv = window.frames[0].RecvMsg(tempmsg[1],tempmsg[4].replace(/SisenMESS_ReLine_Code/g,"<br>"),tempmsg[2]);//MsgShow.aspx页面
                            
                            if(recv==1)
                            {
                                isshowcccyy1 = false;
                            }
                        }
                        catch (ex)
                        {
                        }
                        
                        if(isshowcccyy1)
                        {
                            document.getElementById("MsgHaveShowDiv").style.display = "";//"none";
                        }
                        
                        break;
                    case "MsgGroup":
                        PlaySound("msg");
                        //是否显示在消息上的提示小圆点
                        var isshowcccyy2 = true;
                        try
                        {
                            window.frames[0].RecvMsgGroup(tempmsg[1]);//MsgList.aspx页面
                            isshowcccyy2 = false;
                        }
                        catch (ex)
                        {
                        }
                        try
                        {
                            if(window.frames[0].RecvMsgGroupShow(tempmsg[1])==1)
                            {
                                isshowcccyy2 = false;
                            }
                        }
                        catch (ex)
                        {
                        }
                        //MsgGroupHaveShowDiv
                        
                        
                        if(isshowcccyy2)
                        {
                            document.getElementById("MsgGroupHaveShowDiv").style.display = "";//"none";
                        }
                        break;
                    case "File"://有文件发来
                        PlaySound("msg");
                        SaveLastUserList(_UserNo,tempmsg[1]);
                        //保存消息记录
                        SaveLocalMsgList(_UserNo,tempmsg[1],tempmsg[4].replace(/SisenMESS_ReLine_Code/g,"<br>"),tempmsg[2] ,"0");
                        
                        //保存用户最后通讯概要
                        SaveUserLastMsgSummary(_UserNo,tempmsg[1],tempmsg[3],tempmsg[2]);
                        
                        //是否显示在消息上的提示小圆点
                        var isshowcccyy = true;
                        
                        try
                        {
                            window.frames[0].RecvUserMsg(tempmsg[1],tempmsg[4].replace(/SisenMESS_ReLine_Code/g,"<br>"),tempmsg[2]);//MsgList.aspx页面
                            isshowcccyy = false;
                        }
                        catch (ex)
                        {
                        }
                        try
                        {
                            var recv = window.frames[0].RecvMsg(tempmsg[1],tempmsg[4].replace(/SisenMESS_ReLine_Code/g,"<br>"),tempmsg[2]);//MsgShow.aspx页面
                            
                            if(recv==1)
                            {
                                isshowcccyy = false;
                            }
                        }
                        catch (ex)
                        {
                        }
                        
                        if(isshowcccyy)
                        {
                            document.getElementById("MsgHaveShowDiv").style.display = "";//"none";
                        }
                        
                        break;

                }
            }
            catch (e) {
            }
        }
        //断开连接
        function WSonClose() {
            if (_IsUserLogout || !_IsLogin) {
                return;
            }
            try {
                //终止心跳线程
                _StartUserOnlineState.terminate();
                _StartUserOnlineState = null;
            }
            catch (ex) {
            }
            _IsLogin = false;
            //启用断线重连，如果是用户主动退出，就不进行
            if (_IsUserLogout) {
                return;
            }
            try {
                _UserReConnect.terminate();
                _UserReConnect = null;
            }
            catch (ex) {
            }
            _UserReConnect = new Worker("Scripts/UserReConnectToServer.js");
            _UserReConnect.onmessage = UserReConnectToServerFun;
        }
        //连接出现错误
        function WSonError()
        {
            if (_IsUserLogout)
            {
                return;
            }


            ShowMsgBox("远程连接中断。");
        }

        //用户状态保持
        function UserOnlineSendState(event) {
            try
            {
                var temp = event.data;
                var logininfo = "Online\n" + _UserNo + "\n" + _UserOnline;
                SendMsgToServer(logininfo);
                
                //GetMsgGroupNoReadMsgCount
                
                
            }
            catch (ex)
            {
            }
        }
        //用户定时扫描服务器端未读消息
        function UserScanServerMsgFun(event)
        {
            XMLHttpReadMsgGet();
        }
        
        var xmlReadMsgHttpRequest = null;
        //收到消息，发现没有用户信息，就到服务器端下载用户信息
        function XMLHttpReadMsgGet()
        { 
            xmlReadMsgHttpRequest = new XMLHttpRequest();
            xmlReadMsgHttpRequest.open("POST", "SisenMESS-Mobile-WebService.asmx/GetMsgGroupNoReadMsgCount", true);
            // 当发生状态变化时就调用这个回调函数
            xmlReadMsgHttpRequest.onreadystatechange = ReadMsgGroupMsgCallback;
            // 使用post提交时必须加上下面这行代码
            xmlReadMsgHttpRequest.setRequestHeader("Content-Type","application/x-www-form-urlencoded");
            
            // 向服务器发出一个请求
            xmlReadMsgHttpRequest.send("userNo=" + _UserNo);
        }
        
        function ReadMsgGroupMsgCallback()
        {
            if(xmlReadMsgHttpRequest.readyState == 4)
            {
                if(xmlReadMsgHttpRequest.status == 200)
                {
                    var content = xmlReadMsgHttpRequest.responseText;
                                        
                    if(parseInt(content)>0)
                    {
                        document.getElementById("MsgGroupHaveShowDiv").style.display = "";//"none";
                    }
                }
            }
        }

        //用户断线重连方法
        function UserReConnectToServerFun(event) {
            var temp = event.data;
            if (_Is_UserReConnecting) {
                return;
            }
            _Is_UserReConnecting = true;
            ConnectToServer();
            _Is_UserReConnecting = false;
        }

        //打开相关页面
        function GoToURL(url) 
        {
            if(!_IsLogin)
            {
                return;
            }
            _PageTempName = url;
            document.getElementById("mainFrame").contentWindow.location.href = url;
        }

        //显示提示信息
        function ShowMsgBox(info) {
            //alert(info);
            //ShowSystemInfoBar
            document.getElementById("ShowSystemInfoBar").style.display = "";
            document.getElementById("ShowSystemInfoBar").innerText = info;
        }
        //关闭提醒
        function CloseMsgBox()
        {
            document.getElementById("ShowSystemInfoBar").style.display = "none";
        }

        //退出登录
        function Logout()
        {
            //window.parent.Logout();
            if (!confirm("是否退出？")) {
                    return;
            }

            _IsUserLogout = true;
            _IsLogin = false;
            try {
                _StartUserOnlineState.terminate();
                _StartUserOnlineState = null;
                SendMsgToServer("Exit");
            }
            catch (ex) {

            }

            window.location.href = "Logout.aspx";
        }
        
        //播放声音
        function PlaySound(sound)
        {
            if(!_IsPlaySound)
            {
                return;
            }
            window.msgSound.pause();
            //window.msgSound.src = "Sound/" + sound + ".wav";
            //window.msgSound.load();
            window.msgSound.play();
        }
        //是否播放声音
        function SoundIsPlay()
        {
            _IsPlaySound = !_IsPlaySound;
            if(_IsPlaySound)
            {
                document.getElementById("btn_Sound").src = "Images/SoundOpen.gif";
                window.msgSound.src = "";
                window.msgSound.play();
		        window.msgSound.src = "Sound/msg.wav";
		        window.msgSound.load();
            }
            else
            {
                document.getElementById("btn_Sound").src = "Images/SoundClose.gif";
            }
        }
        //显示或隐藏工具栏
        function ShowOrHideToolBar(isshow)
        {
            if(isshow)
            {
                //显示出状态栏和导航栏
                document.getElementById("HeaderBar").style.visibility = "visible";
                document.getElementById("FootBar").style.visibility = "visible";
            }
            else
            {
                document.getElementById("HeaderBar").style.visibility = "hidden";
                document.getElementById("FootBar").style.visibility = "hidden";
            }
        }
        //打开消息窗口
        function OpenMsgList()
        {
            if(!_IsLogin)
            {
                return;
            }
            var url = "Msg/MsgList.aspx?UserNo=" + _UserNo;
            GoToURL(url);
            SetSelectToolBar("ToolBar_Msg");
            document.getElementById("MsgHaveShowDiv").style.display = "none";//"hidden";
        }
        //打开联系人界面
        function OpenContact()
        {
            if(!_IsLogin)
            {
                return;
            }
            var url ="Contact/ContactList.aspx?UserNo="+ _UserNo;// GoToURL('');
            GoToURL(url);
            SetSelectToolBar("ToolBar_Contact");
        }
        //打开部门分组界面
        function OpenWorkGroup()
        {
            if(!_IsLogin)
            {
                return;
            }
            var url ="WorkGroup/WorkGroup.aspx?UserNo="+ _UserNo;// GoToURL('');
            GoToURL(url);
            SetSelectToolBar("ToolBar_WorkGroup");
        }
        //打开群组界面
        function OpenMsgGroup()
        {
            if(!_IsLogin)
            {
                return;
            }
            var url ="MsgGroup/MsgGroup.aspx?UserNo="+ _UserNo;// GoToURL('');
            GoToURL(url);
            SetSelectToolBar("ToolBar_MsgGroup");
            document.getElementById("MsgGroupHaveShowDiv").style.display = "none";//"none";
        }
        //打开文档
        function OpenDocument()
        {
            //SetSelectToolBar("ToolBar_Document");
        }
        //设置是否选择
        function SetSelectToolBar(name)
        {
            CloseFindBar();
            
            document.getElementById("ToolBar_Msg").src = "Images/MsgList1.gif";
            document.getElementById("ToolBar_Contact").src = "Images/Contact1.gif";
            document.getElementById("ToolBar_MsgGroup").src = "Images/MsgGroup1.gif";
            //document.getElementById("ToolBar_Document").src = "Images/Document1.gif";
            document.getElementById("ToolBar_WorkGroup").src = "Images/WorkGroup1.gif";
            
            switch(name)
            {
                case "ToolBar_Msg":
                    document.getElementById("ToolBar_Msg").src = "Images/MsgList2.gif";
                    break;
                case "ToolBar_Contact":
                    document.getElementById("ToolBar_Contact").src = "Images/Contact2.gif";
                    break;
                case "ToolBar_MsgGroup":
                    document.getElementById("ToolBar_MsgGroup").src = "Images/MsgGroup2.gif";
                    break;
                case "ToolBar_Document":
                    document.getElementById("ToolBar_Document").src = "Images/Document2.gif";
                    break;
                case "ToolBar_WorkGroup":
                    document.getElementById("ToolBar_WorkGroup").src = "Images/WorkGroup2.gif";
                    break;
            }
        }
        //打开或关闭查找用户窗口
        function OpenOrCloseFind()
        {
            if(!_IsLogin)
            {
                return;
            }
            if(document.getElementById("SerachBar").style.display!="")
            {
                document.getElementById("SerachBar").style.display="";
            }
            else
            {
                document.getElementById("SerachBar").style.display="none";
            }
            //SerachBar
        }
        //关闭查找窗口
        function CloseFindBar()
        {
            document.getElementById("SerachBar").style.display="none";
        }
        
//        window.onresize = function() { 
//            //var height = document.body.clientHeight; 
//            //document.getElementById("MainBar").style.top = "0px";
//            document.getElementById("MainBar").style.height = "100%"; 
//        };
    </script>
    <link rel="prefetch" href="Sound/msg.wav" />  
    <style type="text/css">
    <!--
    body {
	    background-color: #666666;
    }
    .ShowCircle {
    width: 8px;
    height: 8px;
    background: red;
    -moz-border-radius: 4px;
    -webkit-border-radius: 4px;
    border-radius: 4px;
    }
    -->
    </style>
</head>
<body  style="overflow:hidden" onload="ConnectToServer();">
    <form id="form1" runat="server">
    <div id="ShowSystemInfoBar" style="position:fixed; top:0px;left:0px; display:none;z-index:100;height:36px; width:100%;background-color:#666666;border:1px #000000;color:White; text-align:center; vertical-align:middle;"></div>
    <div id="HeaderBar" style="position:fixed; top:0px;left:0px; width:100%; height:36px; background-color:#17b4eb;font-family:Tahoma;font-size:12px;z-index:10;visibility:hidden; ">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td style ="width:36px; height:36px; text-align:center;vertical-align:bottom;"><img alt="" id="userInfoImage" src="UserIcon/SisenMESS-User-None-Icon.gif" style='border:1px #e0e1e3 solid;background-color:#FFFFFF' width="28" height="28" runat ="server" /></td>
                <td><span id="userInfoLable" runat="server"></span></td>
                <td>
                    <input id="txt_ServerIp" runat="server" readonly="readonly" style="width: 0px; display:none" type="text" />
                    <input id="txt_UserNo" runat="server" readonly="readonly" style="width: 0px; display:none" type="text" />
                    <input id="txt_UserPass" runat="server" readonly="readonly" style="width: 0px; display:none" type="text" />
                    <input id="txt_UserOnline" runat="server" readonly="readonly" style="width: 0px; display:none" type="text" />
                    <input id="txt_UserImageIcon" runat="server" readonly="readonly" style="width: 0px; display:none" type="text" />
                    <input id="txt_UserTName" runat="server" readonly="readonly" style="width: 0px; display:none" type="text" />
                </td>
                <td style="width:40px;"><img alt="查找" id ="btn_Serach" src="Images/serach.png" width="20" height="20" onclick="OpenOrCloseFind();" /></td>
		        <td style="width:40px;"><img alt="声音" id ="btn_Sound" src="Images/SoundClose.gif" width="24" height="24" onclick="SoundIsPlay();" /></td>
                <td style="width:40px;"><img alt="退出" id ="btn_exit" src="Images/Exit.gif" width="24" height="24" onclick="Logout();" /></td>
                <td style="width:10px;"></td>
            </tr>
        </table>
        <audio id="msgSound" controls="controls" style="display:none;">
            <source src="Sound/msg.wav">
        </audio>
    </div>
    <div id="MainBar" style="position:fixed;overflow:no; left:0px; top:0px; width:100%; height:100%; background-color:#ffffff; z-index:0">
        <iframe id="mainFrame" border="0" marginwidth="0" marginheight="0"
                src="Main.aspx" frameborder="no" style="width:100%;height:100%;"
                scrolling="auto" name="mainFrame"></iframe>
    </div>
    <div id="FootBar" style="position:fixed;left:0px;bottom:0;top:expression(document.documentElement.clientHeight + document.documentElement.scrollTop - this.offsetHeight);background-color:#f3f3f3;height:55px;width:100%;font-family:Tahoma; font-size:12px; border-top:1px solid #cccccc;z-index:20;visibility:hidden;">
        <table style="height:100%; width:100%; background-color:#d3e5f4;" align="center" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td>&nbsp;</td>
                <td style="text-align:center; width:34px;"><div id = "MsgHaveShowDiv" class="ShowCircle" style="position:fixed;width:8px; height:8px;margin:0 22px; display:none"></div><img alt="消息" id ="ToolBar_Msg" src="Images/MsgList1.gif" width="34" height="40" onclick="OpenMsgList();" /></td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td style="text-align:center; width:34px;"><img alt="联系人" id ="ToolBar_Contact" src="Images/Contact1.gif" width="34" height="40" onclick="OpenContact();" /></td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td style="text-align:center; width:34px;"><div id = "MsgGroupHaveShowDiv" class="ShowCircle" style="position:fixed;width:8px; height:8px;margin:0 22px; display:none"></div><img alt="群组" id ="ToolBar_MsgGroup" src="Images/MsgGroup1.gif" width="34" height="40" onclick="OpenMsgGroup();" /></td>
                <td>&nbsp;</td>
                <td>&nbsp;</td>
                <td style="text-align:center; width:34px;"><img alt="部门" id ="ToolBar_WorkGroup" src="Images/WorkGroup1.gif" width="34" height="40" onclick="OpenWorkGroup();" /></td>
                <td>&nbsp;</td>
            </tr>
        </table>
    </div>
    <div id="SerachBar" style="position:fixed;overflow:no; left:0px; top:0px; width:100%; height:100%; background-color:#ffffff; z-index:1;display:none;">
        <iframe id="SerachFrame" border="0" marginwidth="0" marginheight="0"
                src="FindUser/FindUsers.aspx" frameborder="no" style="width:100%;height:100%;"
                scrolling="auto" name="SerachFrame"></iframe>
    </div>
    </form>
</body>
</html>
